<?php
/**
 * Módosítva: 2010.03.06.
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * @ignore
 */
require_once dirname(__FILE__).'/../REPClasses.class.php';
/*
 * REPFIleItems importálása
 */
REPClasses::import('REPFileItems');

/**
 * XML-ben tárolt adatok lapozására használható osztály
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REPXmlItems extends REPFileItems
{
	/**
	 *
	 * @param string $file A beolvasandó xml fájl
	 * @param array $tags a cella tag-ek, amiket le akarunk kérdezni.
	 *			Elhagyása esetén egy tag-et se olvas be ellentétben a
	 *			{@link REPFileItems} osztállyal.
	 */
	public function  __construct($file,$tags=array())
	{
		parent::__construct($file, $tags);
		if (count($this->items)) return;
		$this->init($tags);
	}
	/**
	 * Beolvassa az xml fájlt, és beállítja a mezők értékeit. 
	 *
	 * @param array $tags a cella tag-ek, amiket le akarunk kérdezni.
	 *			Elhagyása esetén egy tag-et se olvas be ellentétben a
	 *			{@link REPFileItems} osztállyal.
	 */
	protected function init($tags=array())
	{
		$dom = new DOMDocument();
		$dom->load($this->filename);
		$rootNode = $dom->getElementsByTagName('*')->item(0);
		$rowTag = $rootNode->getElementsByTagname('*')->item(0)->nodeName;

		$rows = $rootNode->getElementsByTagName($rowTag);
		foreach ($rows as $row)
		{
			$rowarray=array();
			foreach ($tags as $tag)
			{
				$rowarray[$tag] = &$dom->saveXML($row->getElementsByTagName($tag)->item(0));
			}
			$this->items[] = $rowarray;
		}
	}
}
?>
