<?php
/**
 * Módosítva: 2010.03.06.
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * @ignore
 */
require_once dirname(__FILE__).'/../../REPClasses.class.php';
/*
 * AREPItems importja az örököltetéshez 
 */
REPClasses::import('AREPItems');
/**
 * MySQL adatbázisban egy lekérdezés eredményeit tároló iterálható
 * objektumot hoz létre
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REPMySQLItems extends AREPItems
{
	/**
	 * Adatbázis kapcsolatazonosító
	 * @var resource
	 */
	protected $connectId = null;
	/**
	 * Lekérdezés erőforrásazonosítója
	 * @var resource
	 */
	protected $resource = null;

	/**
	 * A select lekérdezés from utáni része.
	 * @var string
	 */
	protected $from = "";
	/**
	 * A select lekérdezés-ben a lekérdezendő mezőnevek listája
	 * vesszővel elválasztva
	 * @var string
	 */
	protected $fields = "";

	/**
	 * A limit záradék offset értéke
	 * @var int
	 */
	protected $offset = 0;

	/**
	 * A limit záradék limit értéke
	 * @var int
	 */
	protected $limit = null;

	/**
	 * Az iteráció közben az aktuális offset érték
	 * @var int
	 */
	protected $pos = 0;
	/**
	 * Ettől az indextől kezdve kezdődik az iteráció. Az előtte lévő
	 * rekordokat átugorja. 
	 * @var int
	 */
	protected $startIndex = 0;

	/**
	 *
	 * @var Az aktuális iterálható rekordok száma
	 */
	protected $count = null;
	/**
	 * A limit nélküli lekérdezésre illeszkedő sorok száma
	 * @var int
	 */
	protected $max = null;

	/**
	 * 
	 * @param string $from A select lekérdezés from utáni része
	 * @param array $fields A lekérdezendő mezők listája tömbben
	 *				Elhagyása esetén minden mezőt lekérdez
	 * @param resource $connectId Kapcsolatazonosító
	 */
    public function  __construct($from,$fields=array(),$connectId=null)
	{
		$this->from = $from;
		$this->fields = (is_array($fields) and count($fields))
				? implode(', ',$fields) : '*';
		if (is_resource($connectId))
		{
			$this->connectId = $connectId;
		}
	}

	/**
	 * @return resource A kapcsolatazonosító
	 */
	public function connectId()
	{
		return $this->connectId;
	}

	/**
	 * Beállítja, illetve lekérdezi a {@link $limit} értékét.
	 *
	 *
	 * @param $arg1 Ha a 2. paraméter üres, akkor limit. Egyébként offset
	 * @param $arg2 offset
	 *
	 * @return string Az sql-be beillesztendő limit záradék
	 */
	public function limit($arg1=null, $arg2=null)
	{
		$args = func_get_args();
		$num = func_num_args();
		if ($num >= 2)
		{
			$this->offset = (int)$args[0];
			$this->limit = (int)$args[1];
		} 
		else if ($num == 1)
		{
			$this->limit = (int)$args[0];
		}
		$ret = '';
		if (!is_null($this->limit))
		{
			$ret = 'limit ';
			if (!is_null($this->offset))
			{
				$ret .= $this->offset.", ";
			}
			$ret .= $this->limit;
		}
		return $ret;
	}

	/**
	 * @return resource A lekérdezés erőforrás azonosítója
	 */
	protected function resource()
	{ 
		if (!is_resource($this->resource))
		{
			$limit = (!is_null($this->limit))
				? "limit ".$this->offset.", ".$this->limit : "";
			$sql = "select ".$this->fields." from ".$this->from. " ".$limit; 
			$this->resource = $this->query($sql);
		} 
		return $this->resource;
	}

	/**
	 *
	 * @param string $sql Komplett sql lekérdezés
	 * @param resource $connectId Kapcsolatazonosító
	 * @return resource A lekérdezés erőforrás azonosítója
	 */
	protected function query($sql,$connectId=null)
	{
		if (!is_resource($connectId))
		{
			$connectId = $this->connectId;
		}
		$resource = !is_resource($connectId)
				? mysql_query($sql)
				: mysql_query($sql,$connectId);
		return $resource;
	}

	/**
	 * Létrehoz egy új azonos típusú példányt, mint az objektum, amin hívjuk a metódust. 
	 *
	 * @param resource $connectId Kapcsolatazonosító
	 * @param int $offset Lekérdezés limit záradékának offset értéke
	 * @param int $limit Limit záradék limit értéke
	 * @return REPMySQLItems
	 */
	public function newInstance($connectId,$offset, $limit)
	{
		$obj = clone $this;
		if (is_resource($obj->resource))
		{
			$obj->startIndex = (int)$offset;
		}
		$obj->limit($offset, $limit);
		return $obj;
	}

	/**
	 * @ignore
	 */
	public function offsetExists($offset)
	{
		return $this->count() > (int)$offset;
	}

	/**
	 * @ignore
	 */
	public function offsetUnset($offset)
	{
		throw new Exception("unset művelet tiltott (".get_class($this).")");
	}

	/**
	 * @ignore
	 */
	public function offsetGet($offset)
	{
		$offset = $offset+$this->startIndex;
		mysql_data_seek($this->resource(),(int)$offset);
		return isset($this[$offset]) ? mysql_fetch_assoc($this->resource()) : null;
	}

	/**
	 * @ignore
	 */
	public function offsetSet($offset, $value)
	{
		throw new Exception("Értékadás tiltott (".get_class($this).")");
	}

	/**
	 * @ignore
	 */
	public function current()
	{
		$pos = $this->pos;
		mysql_data_seek($this->resource(),$pos);
		return mysql_fetch_assoc($this->resource());
	}

	/**
	 * @ignore
	 */
	public function key()
	{
		$pos = $this->pos-$this->startIndex;
		return $pos < $this->count() ? $pos : null;
	}

	/**
	 * @ignore
	 */
	public function next()
	{
		$this->pos++;
	}

	/**
	 * @ignore
	 */
	public function rewind()
	{
		$this->pos = $this->startIndex;
	}

	/**
	 * @ignore
	 */
	public function valid()
	{
		return $this->key() !== null;
	}

	/**
	 * @return int A lekérdezésre limit nélkül illeszkedő sorok száma
	 */
	public function max()
	{
		if (is_null($this->max))
		{
			$this->max = array_shift(mysql_fetch_row(mysql_query(
				"select count(*) from ".$this->from)));
		}
		return $this->max;
	}

	/**
	 * @return int A lekérdezésre limit -tel együtt illeszkedő sorok száma
	 */
	public function count()
	{
		if (is_null($this->count))
		{
			$select = "select count(*) from
				(select * from ".$this->from." ".$this->limit().") as t";
			$query = $this->query($select);
			$fetch = mysql_fetch_row($query);
			$this->count = (int)array_shift($fetch);
		}
		else if (is_resource($this->resource))
		{
			$this->count = mysql_num_rows($this->resource);
		}
		$count = $this->count-$this->startIndex;
		if (!is_null($this->limit) and $this->limit < $count)
		{
			$count = $this->limit;
		}

		return $count;
	}
}
?>
