<?php
/**
 * Módosítva: 2010.03.06.
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * @ignore
 */
require_once dirname(__FILE__).'/../../REPClasses.class.php';
REPClasses::import('AREPagination');
REPClasses::import('REPMySQLItems');

/**
 * MySQL adatbázisban tárolt adatok lapozására. 
 *
 * {@example mysqlpagination.php}
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REMySQLPagination extends AREPagination
{
	/**
	 * @var REPMySQLItems
	 */
	protected $items = null;
	/**
	 *
	 * @param REPMySQLItems $items
	 */
    public function  __construct(REPMySQLItems $items)
	{
		$this->items = $items;
	}

	/**
	 * @see $pagevar
	 * @param int $page Elhagyása esetén az url-ből veszi az oldalszámot.
	 * @return REPFileItems Aktuális oldal rekordjait tartalmazó objektum
	 */
	public function page($page=null)
	{
		$page = $page !== null ? (int)$page : $this->pageNumber();
		$maxpage = $this->maxpage();
		if ($page <= 0)
		{
			$page = 1;
		}
		else if ($page >= $maxpage)
		{
			$page = $maxpage;
		}

		$offset = ($page-1) * $this->itemPerPage();
		return $this->items->newInstance($this->items->connectId(),$offset,$this->itemPerPage());
	}

	/**
	 * @see AREPagination::maxpage()
	 * @return int
	 */
	public function maxpage()
	{
		return ceil($this->items->max()  / $this->itemPerPage());
	}
}
?>
