<?php
/**
 * Módosítva: 2010.03.06.
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * @ignore
 */
require_once dirname(__FILE__).'/../REPClasses.class.php';
/*
 * AREPItems importálása
 */
REPClasses::import('AREPItems');
/**
 * Egyszerű, szöveges fájlok tartalmát iterálhatóvá tevő osztály.
 * Egy sor egy rekord. És egy rekordban a mezőket tetszőlegesen
 * megadható karaktersor választja el. 
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REPFileItems extends AREPItems
{
	/**
	 * A fájlban levő rekordok tömbje. Két dimenziós. 
	 * @var array
	 */
	protected $items = array();
	/**
	 * A mezőket elválasztó karaktersor
	 * @var string
	 */
	private $sep = '&&';
	/**
	 * Beolvasandó fájl neve
	 * @var string
	 */
	protected $filename = null;

	/**
	 * @see init()
	 *
	 * @param mixed $file Ha string, akkor a {@link $filename fájlnevet} állítja be.
	 *		Ha tömb, akkor rögtön az {@link $items} tulajdonságot.
	 *		Így akár előre beolvasott tartalmat, vagy tömböt is
	 *		lehet lapozni vele. 
	 * @param array $indexes Lekérdezendő mezők listája Részletek az {@link init()} metódusnál. 
	 * @param string $sep Mezőket elválasztó karaktersor. 
	 */
	public function __construct($file,$indexes=array(), $sep='&&')
	{
		if (is_string($file))
		{
			$this->filename = $file;
		}
		else if (is_array($file))
		{
			$this->items = $file;
		}
		if (count($this->items)) return;
		$this->init($indexes, $sep);
	}
	/**
	 * Beolvassa a megfelelő fájlt, ha szükséges
	 * és beállítja az indexeit a mezőknek.
	 *
	 * @param array $indexes Két dimenziós tömb, amiben megadható,
	 *		hogy melyik oszlopnak mi legyen az asszociatív indexe.
	 *		Az eredeti tömbben azonos indexű elem új neve lesz az
	 *		$indexes adott eleme. Ezzel sorrend is változtatható, ha megadjuk
	 *		kézzel az indexeket a tömbben.
	 * @param string $sep Mezőket elválasztó karaktersor.
	 */
	protected function init($indexes=array(),$sep = '&&')
	{
		$this->sep = $sep;
		if (!is_null($this->filename) and file_exists($this->filename))
		{
			$this->items = file($this->filename);
		}

		if (isset($this->items[0]) and !is_array($this->items[0]))
		{
			foreach ($this->items as &$item)
			{
				$item = explode($sep, $item);
				if (!is_array($indexes) or !count($indexes))
				{
					continue;
				}
				$tmp = array();
				foreach ($indexes as $key => $value)
				{
					if (!isset($item[$key])) continue;
					$tmp[$value] = $item[$key];
				}
				$item = $tmp;
			}
		}
	}

	/**
	 * Létrehoz egy új azonos típusú példányt, mint az objektum, amin hívjuk a metódust. 
	 *
	 * @param array $items Az új példány {@link $items} tulajdonsága ezt fogja tartalmazni
	 * @return REPFileItems A leszármaztatott osztályokból származtatott
	 *		objektumok ezen metódusa az adott osztály típusú objektummal
	 *		tér vissza.
	 */
	public function newInstance($items)
	{
		$ref = new ReflectionObject($this);
		$obj = $ref->newInstance($this->filename);
		$props = $ref->getProperties();
		$obj->items = $items;
		foreach ($props as  $prop => $value)
		{
			if ($prop == 'items') continue;
			$obj->$prop = $value;
		}
		
		return $obj;
	}

	/**
	 * @ignore
	 */
	public function offsetExists($offset)
	{
		return isset($this->items[$offset]);
	}
	/**
	 * @ignore
	 */
	public function offsetUnset($offset)
	{
		unset($this->items[$offset]);
	}
	/**
	 * @ignore
	 */
	public function offsetGet($offset)
	{
		return isset($this->items[$offset]) ? $this->items[$offset] : null;
	}

	/**
	 * @ignore
	 */
	public function offsetSet($offset, $value)
	{
		$this->items[$offset] = $value;
	}

	/**
	 * {@link $items} tömb mérete
	 * @return int
	 */
	public function count()
	{
		return count($this->items);
	}

	/**
	 * @ignore
	 */
	public function current()
	{
		return current($this->items);
	}

	/**
	 * @ignore
	 */
	public function key()
	{
		return key($this->items);
	}

	/**
	 * @ignore
	 */
	public function next()
	{
		next($this->items);
	}

	/**
	 * @ignore
	 */
	public function rewind()
	{
		reset($this->items);
	}

	/**
	 * @ignore
	 */
	public function valid()
	{
		return key($this->items) !== null;
	}
}
?>
