<?php
/**
 * Módosítva: 2010.03.06.
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * @ignore
 */
require_once dirname(__FILE__).'/../REPClasses.class.php';
/*
 * AREPagination imortálása
 */
REPClasses::import('AREPagination');
/*
 * REPFileItems importálása
 */
REPClasses::import('REPFileItems');
/**
 * {@link REPFileItems} objektumok lapozására szólgáló osztály
 *
 * {@example filepagination.php}
 * {@example xmlpagination.php}
 *
 * @see AREPagination
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REFilePagination extends AREPagination
{
	/**
	 *
	 * @var REPFileItems
	 */
	protected $items = null;
	/**
	 *
	 * @param REPFileItems $file 
	 */
	public function  __construct(REPFileItems $file)
	{
		$this->items = $file;
	}

	/**
	 * @see $pagevar
	 * @param int $page Elhagyása esetén az url-ből veszi az oldalszámot. 
	 * @return REPFileItems Aktuális oldal rekordjait tartalmazó objektum
	 */
	public function page($page=null)
	{ 
		$page = $page !== null ? (int)$page : $this->pageNumber();
		$maxpage = $this->maxpage(); 
		$c = $this->items->count();
		if ($page <= 0)
		{
			$page = 1;
		}
		else if ($page >= $maxpage)
		{
			$page = $maxpage;
		}

		$offset = ($page-1) * $this->itemPerPage();
		$end = $offset + $this->itemPerPage();
		$ret = array();
		for ($i=$offset; $i < $c and $i < $end; $i++)
		{
			$ret[] = $this->items[$i];
		}
		return $this->items->newInstance($ret);
	}

	/**
	 * @see AREPagination::maxpage()
	 * @return int
	 */
	public function maxpage()
	{
		return ceil($this->items->count()  / $this->itemPerPage());
	}
}
?>
