<?php
/**
 * Módosítva: 2010.03.06. 
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @version 1.0
 * @package REPagination
 */

/**
 * A lapozóhoz tartozó osztályok telepítését, és
 * lekérdezését végző osztály. 
 *
 * @author Takács Ákos (Rimelek), programmer [at] rimelek [dot] hu
 * @copyright Copyright (C) 2010, Takács Ákos
 * @package REPagination
 */
class REPClasses
{
	/**
	 * Ennek az osztálynak pontos útvonala
	 * @var string
	 */
	private static $PATH = __FILE__;
	/**
	 * A telepített osztályok útvonalai. 
	 * @var array
	 */
	private static $classes = array();
	/**
	 * Ha már lefutott egyszer a {@link runInstall()} metódus, akkor true.
	 * Egyébként false
	 * @var bool
	 */
	private static $installed = false;
	/**
	 * A telepített osztályok nevei.
	 * Index a kisbetűs formátum. 
	 * @var array
	 */
	private static $lower = array();
	/**
	 * Ennek az osztálynak a könyvtárneve.
	 * @return string
	 */
	public static function dir()
	{
		return dirname(self::$PATH).'/';
	}
	/**
	 * Egy osztály telepítése a lapozóba. 
	 * @param string $class {@link import()}-ban használható név
	 * @param string $path Az telepítendő osztály útvonala ennek az osztálynak
	 *				az könyvtárszintjétől számítva.
	 */
    public static function install($class,$path)
	{
		$lower = strtolower($class);
		if (isset(self::$lower[$lower]))
		{
			throw new Exception("Osztálynév ütközés");
		}
		$classpath = self::dir().ltrim($path,'/');
		if (!file_exists($classpath))
		{
			throw new Exception("Nincs ilyen osztály. ($class: $classpath) Nem telepíthető");
		}
		self::$classes[$class] = $path;
		self::$lower[$lower] = $class;
	}

	/**
	 * Egy osztály importálása. 
	 * @param string $class Importálandó osztály telepített neve. 
	 */
	public static function import($class)
	{
		$lower = strtolower($class);
		if (!isset(self::$lower[$lower]))
		{
			throw new Exception("Nincs ilyen osztály. ($class) Nem importálható");
		}
		require_once self::dir().self::$classes[self::$lower[$lower]];
	}
	/**
	 * Az install.php -ben levő osztályok telepítésének elindítása
	 * @return <type> 
	 */
	public static function runInstall()
	{
		if (self::$installed) return;
		require_once REPClasses::dir().'/../install.php';
		self::$installed = true;
	}
	/**
	 * A telepített osztályok nevei és útvonalai.
	 * Asszociatív tömb
	 * @return array
	 */
	public static function installedClasses()
	{
		return self::$classes;
	}
}
/**
 * Telepítés indítása az osztály importálásakor
 */
REPClasses::runInstall();
?>
